
%% position and orientation of the flagellum wrt the cell body (parametrs)

thd=0.1;
phd=6.2;

thR=2.6;
psiR=4.6;
phR=1.6;


rhoM=1.4;
rhom=0.24;

[ xbody , ybody ,  zbody] = ellipsoid(0,0,0,rhom + 0.02,rhom +0.02,rhoM);

flag1=0*r1;
flag2=0*r2;
flag3=0*r3;

for inst=1:(ny/10 +1)
flag1(:,inst) =  rhom*sin(thd)*sin(phd) + ...
                ( cos(thR)*cos(psiR) )*r1(:,inst) + ...
                (-cos(phR)*sin(psiR) + sin(phR)*sin(thR)*cos(psiR) )*r2(:,inst) + ...
                ( sin(phR)*sin(psiR) + cos(phR)*sin(thR)*cos(psiR) )*r3(:,inst);
 
flag2(:,inst) =  rhom*sin(thd)*cos(phd) + ...
                ( cos(thR)*sin(psiR) )*r1(:,inst) + ...
                ( cos(phR)*cos(psiR) + sin(phR)*sin(thR)*sin(psiR) )*r2(:,inst) + ...
                (-sin(phR)*cos(psiR) + cos(phR)*sin(thR)*sin(psiR) )*r3(:,inst);

flag3(:,inst) =  rhoM*cos(thd) + ...
                (-sin(thR) )*r1(:,inst) + ...
                ( sin(phR)*cos(thR) )*r2(:,inst) + ...  
                ( cos(phR)*cos(thR) )*r3(:,inst);                                           
end

%% animated plot

for turns=1:6
for inst=1:4:(ny/10) 
surf( xbody , ybody ,  zbody , 'FaceColor',[ 0.1 0.9 0.1],'EdgeColor',[ 0.5 0.5 0.5])
hold on
tubeplot([ flag1(:,inst)' ; flag2(:,inst)' ; flag3(:,inst)'],0.01,5);
hold off
grid on
daspect([1 1 1])
camlight(70,30)
xlim([-0.6 0.6])
ylim([-0.6 0.6])
zlim([0.8, 1.75])
xlabel('x')
ylabel('y')
view([ -200 - 8*(turns*(ny/10) + inst)/(ny/10) ,  10])
drawnow
pause(0.01)
end
end

